<?php $__env->startSection('main-content'); ?>

<section class="section">
    <div class="section-header">
        <h1><?php echo e(__('attendance.attendance')); ?></h1>
        <?php echo e(Breadcrumbs::render('attendance')); ?>

    </div>

    <div class="section-body">
        <div class="row">
            <div class="col-12">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if(!blank($attendance)): ?>
                            <div class="float-right  d-flex text-center" style="margin-left:auto">
                                <p class="mr-2">
                                    <span class="clock-span"><i class="fas fa-4x fa-clock"></i>
                                        <?php echo e(date('g:i A')); ?></span><br>
                                    <?php if($attendance->checkin_time): ?>
                                    <span class="text-success">
                                        <?php echo e(__('attendance.clock_in_at')); ?>- <?php echo e($attendance->checkin_time); ?>

                                        <?php if($attendance->checkout_time): ?> <span class="text-danger ml-2">  <?php echo e(__('attendance.clock_out_at')); ?> -
                                            <?php echo e($attendance->checkout_time); ?></span><?php endif; ?>
                                    </span>
                                    <?php endif; ?>
                                </p>
                                <?php if(!$attendance->checkout_time): ?>
                                <form action="<?php echo e(route('admin.attendance.clockout')); ?>" method="post">
                                    <?php echo e(csrf_field()); ?>

                                    <button class="btn  d-flex inputbtnclockout align-items-center btn-dark"
                                        type="submit"><i class="fas fa-4x fa-sign-out-alt"></i><?php echo e(__('attendance.clock_out')); ?></button>
                                </form>
                                <?php endif; ?>
                            </div>
                            <?php else: ?>
                            <div class="float-right  d-flex text-center" style="margin-left:auto">
                                <p class="mt-2 mr-2">
                                    <span class="clock-span"><i class="fas fa-4x fa-clock"></i>
                                        <?php echo e(date('g:i A')); ?></span><br>
                                </p>
                                <button type="button" class="btn  d-flex inputbtnclockin align-items-center btn-success"
                                    data-toggle="modal" data-target="#exampleModal"><i
                                        class="fas fa-4x fa-sign-out-alt"></i><?php echo e(__('attendance.clock_in')); ?></button>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="maintable"
                                data-url="<?php echo e(route('admin.attendance.get-attendance')); ?>">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('levels.id')); ?></th>
                                        <th><?php echo e(__('levels.image')); ?></th>
                                        <th><?php echo e(__('attendance.user')); ?></th>
                                        <th><?php echo e(__('attendance.working')); ?></th>
                                        <th><?php echo e(__('attendance.date')); ?></th>
                                        <th><?php echo e(__('attendance.clock_in')); ?></th>
                                        <th><?php echo e(__('attendance.clock_out')); ?></th>
                                        <th><?php echo e(__('levels.actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('attendance.clock_in')); ?> - <span class="clock-span"><i
                            class="fas fa-4x fa-clock"></i> <?php echo e(date('g:i A')); ?></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('admin.attendance.clockin')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label><?php echo e(__('attendance.working_from')); ?></label>
                        <input type="text" name="title" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('title')); ?>" placeholder="<?php echo e(__('attendance.eg_office_home_etc')); ?>">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('attendance.close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('attendance.clock_in')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-select-bs4/css/select.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/modules/datatables/media/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/modules/datatables.net-select-bs4/js/select.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/attendance/index.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mmatwoco/public_html/vms/resources/views/admin/attendance/index.blade.php ENDPATH**/ ?>